USE OLAP
--Average of sales up to this point
SELECT year,month,total_sales
       ,avg(total_sales) over(order by year,month) as avg_sale_up_to_this_point
FROM sales_by_year_and_month
ORDER BY year,month

--Averages for the last 3 months?
SELECT year,month,total_sales
       ,avg(total_sales) over(order by year,month rows 2 preceding) as three_monthly_average
FROM sales_by_year_and_month
ORDER BY year,month

--Consider this row, and the rows either side.
SELECT year,month,total_sales
       ,avg(total_sales) over(order by year,month 
	                          rows between 1 preceding and 1 following) as three_monthly_averages
FROM sales_by_year_and_month
ORDER BY year,month

--Between 6 and 3 months ago
SELECT year,month,total_sales
       ,avg(total_sales) over(order by year,month 
	                          rows between 6 preceding and 3 preceding) as three_monthly_averages
FROM sales_by_year_and_month
ORDER BY year,month

--Between earliest and most recent.
SELECT year,month,total_sales
       ,avg(total_sales) over(order by year,month 
	                          rows between 3 preceding and 6 preceding) as three_monthly_averages
FROM sales_by_year_and_month
ORDER BY year,month

